graphics.off()
rm(list=ls(all=TRUE))
fileNameRoot="PoissonExponentialJagsSTZ" # for constructing output filenames
if ( .Platform$OS.type != "windows" ) { 
	windows <- function( ... ) X11( ... ) 
}
require(rjags)        
# Code modified by Timothy Kelley from: 
# Kruschke, J. K. (2011). Doing Bayesian Data Analysis:      
# A Tutorial with R and BUGS. Academic Press / Elsevier.
#------------------------------------------------------------------------------
# THE MODEL.

modelstring = "
		model {
		for ( i in 1:Ncells ) {
		y[i] ~ dpois( lambda[i] )
		lambda[i] <- exp( a0 + a1[x1[i]] + a2[x2[i]] + a1a2[x1[i],x2[i]] )
		}
		#
		a0 ~ dnorm(0,0.001)
		#
		for ( j1 in 1:Nx1Lvl ) { a1[j1] ~ dnorm( 0.0 , a1tau ) }
		a1tau <- 1 / pow( a1SD , 2 )
		a1SD ~ dgamma(2.618,0.809) # mode=2,sd=2
		#
		for ( j2 in 1:Nx2Lvl ) { a2[j2] ~ dnorm( 0.0 , a2tau ) }
		a2tau <- 1 / pow( a2SD , 2 )
		a2SD ~ dgamma(2.618,0.809) # mode=2,sd=2
		#
		for ( j1 in 1:Nx1Lvl ) { for ( j2 in 1:Nx2Lvl ) {
		a1a2[j1,j2] ~ dnorm( 0.0 , a1a2tau )
		} }
		a1a2tau <- 1 / pow( a1a2SD , 2 )
		a1a2SD ~ dgamma(2.618,0.809) # mode=2,sd=2
		# Convert a0,a1[],a2[],a1a2[,] to sum-to-zero b0,b1[],b2[],b1b2[,] :
		for ( j1 in 1:Nx1Lvl ) { for ( j2 in 1:Nx2Lvl ) {
		m[j1,j2] <- a0 + a1[j1] + a2[j2] + a1a2[j1,j2]  
		} }
		b0 <- mean( m[1:Nx1Lvl,1:Nx2Lvl] )
		for ( j1 in 1:Nx1Lvl ) { b1[j1] <- mean( m[j1,1:Nx2Lvl] ) - b0 }
		for ( j2 in 1:Nx2Lvl ) { b2[j2] <- mean( m[1:Nx1Lvl,j2] ) - b0 }
		for ( j1 in 1:Nx1Lvl ) { for ( j2 in 1:Nx2Lvl ) {
		b1b2[j1,j2] <- m[j1,j2] - ( b0 + b1[j1] + b2[j2] )  
		} }
		}
		" # close quote for modelstring
# Write model to a file, and send to JAGS:
writeLines(modelstring,con="model.txt")

#------------------------------------------------------------------------------
# THE DATA.
# Specify data source:
dataSource = c("FixationAnalysis.csv")
if ( dataSource == "FixationAnalysis.csv" ) {
	fileNameRoot = paste( fileNameRoot , dataSource , sep="" )
	initialImport = read.csv(dataSource)
#	firstFilter = initialImport[1:156,]
#	transDuration = log(firstFilter$Duration)
#	secondFilter = cbind(firstFilter,transDuration)
#	colnames(secondFilter) = c(colnames(firstFilter),"logDuration")
	y = initialImport$Fixations
	y = y+1
	x1 = initialImport$SmallCategory
	x2 = initialImport$Task
	
	x1names = as.factor(c("Novice","Computer Expert","Security Expert"))
	x2names = levels(as.factor(initialImport$Task))
	normalize = function( v ){ return( v / sum(v) ) }
	Ncells = length(y)
	Nx1Lvl = length(unique(x1))
	Nx2Lvl = length(unique(x2))
	x1contrastList = list(NovicevCompExpert = (x1names=="Novice")-(x1names=="Computer Expert"),
			NovicevSecExpert = (x1names=="Novice")-(x1names=="Security Expert"),
			CompExpertvSecExpert = (x1names=="Computer Expert")-(x1names=="Security Expert"),
			SecExpertvOthers = normalize(x1names!="Security Expert")-(x1names=="Security Expert"))
	x2contrastList = list( FacebookvOpenID = normalize(x2names=="1"|x2names=="2"|x2names=="3"|x2names=="4"|x2names=="5"|x2names=="6")-
					normalize(x2names=="7"|x2names=="8"|x2names=="9"|x2names=="10"),
			Task1vsOthers = (x2names=="1")-normalize(x2names!="1"),
			Task6vsOthers = (x2names=="6")-normalize(x2names!="6"),
			Task1and6vsOthers = normalize(x2names=="1"|x2names=="6")-normalize(x2names!="1"&x2names!="6"),
			FacebookvOpenIDwo1and6 = normalize(x2names=="2"|x2names=="3"|x2names=="4"|x2names=="5")-
					normalize(x2names=="7"|x2names=="8"|x2names=="9"|x2names=="10"))
	x1x2contrastList = list(SecExpertvNovicesTasks1and6 = outer((x1names=="Novice")-(x1names=="Security Expert"),normalize(x2names=="1"|x2names=="6")))
}

dataList = list(
		y = y ,
		x1 = x1 ,
		x2 = x2 ,
		Ncells = Ncells ,
		Nx1Lvl = Nx1Lvl ,
		Nx2Lvl = Nx2Lvl
)

#------------------------------------------------------------------------------
# INTIALIZE THE CHAINS.

theData = data.frame( y=log(y) , x1=factor(x1,labels=x1names) ,
		x2=factor(x2,labels=x2names) )
a0 = mean( theData$y )
a1 = aggregate( theData$y , list( theData$x1 ) , mean )[,2] - a0
a2 = aggregate( theData$y , list( theData$x2 ) , mean )[,2] - a0
linpred = as.vector( outer( a1 , a2 , "+" ) + a0 )
a1a2 = aggregate( theData$y, list(theData$x1,theData$x2), mean)[,3] - linpred
initsList = list( a0 = a0 , a1 = a1 , a2 = a2 ,
		a1a2 = matrix( a1a2 , nrow=Nx1Lvl , ncol=Nx2Lvl ) ,
		a1SD = max(sd(a1),0.1) , a2SD = max(sd(a2),0.1) , a1a2SD = max(sd(a1a2),0.1) )

#------------------------------------------------------------------------------
# RUN THE CHAINS

parameters = c( "a0" ,  "a1" ,  "a2" ,  "a1a2" , 
		"b0" ,  "b1" ,  "b2" ,  "b1b2" ,
		"a1SD" , "a2SD" , "a1a2SD" )
adaptSteps = 12000
burnInSteps =15000
nChains = 25 
numSavedSteps=250000
thinSteps=75
nIter = ceiling( ( numSavedSteps * thinSteps ) / nChains )
# Create, initialize, and adapt the model:
jagsModel = jags.model( "model.txt" , data=dataList , inits=initsList , 
		n.chains=nChains , n.adapt=adaptSteps )
# Burn-in:
cat( "Burning in the MCMC chain...\n" )
update( jagsModel , n.iter=burnInSteps )
# The saved MCMC chain:
cat( "Sampling final MCMC chain...\n" )
codaSamples = coda.samples( jagsModel , variable.names=parameters , 
		n.iter=nIter , thin=thinSteps )
# resulting codaSamples object has these indices: 
#   codaSamples[[ chainIdx ]][ stepIdx , paramIdx ]

#------------------------------------------------------------------------------
# EXAMINE THE RESULTS

checkConvergence = F
if ( checkConvergence ) {
	show( summary( codaSamples ) )
	windows()
	plot( codaSamples , ask=F )  
	windows()
	autocorr.plot( codaSamples[[1]][,c("a0","a1SD","a2SD","a1a2SD")] )
}

# Convert coda-object codaSamples to matrix object for easier handling.
# But note that this concatenates the different chains into one long chain.
# Result is mcmcChain[ stepIdx , paramIdx ]
mcmcChain = as.matrix( codaSamples )


# Extract the SDs:
a1SDSample = mcmcChain[,"a1SD"]
a2SDSample = mcmcChain[,"a2SD"]
a1a2SDSample = mcmcChain[,"a1a2SD"]

# Extract b values:
b0Sample = mcmcChain[, "b0" ]
chainLength = length(b0Sample)
b1Sample = array( 0 , dim=c( dataList$Nx1Lvl , chainLength ) )
for ( x1idx in 1:dataList$Nx1Lvl ) {
	b1Sample[x1idx,] = mcmcChain[, paste("b1[",x1idx,"]",sep="") ]
}
b2Sample = array( 0 , dim=c( dataList$Nx2Lvl , chainLength ) )
for ( x2idx in 1:dataList$Nx2Lvl ) {
	b2Sample[x2idx,] = mcmcChain[, paste("b2[",x2idx,"]",sep="") ]
}
b1b2Sample = array(0, dim=c( dataList$Nx1Lvl , dataList$Nx2Lvl , chainLength ) )
for ( x1idx in 1:dataList$Nx1Lvl ) {
	for ( x2idx in 1:dataList$Nx2Lvl ) {
		b1b2Sample[x1idx,x2idx,] = mcmcChain[, paste( "b1b2[",x1idx,",",x2idx,"]",
						sep="" ) ]
	}
}

source("plotPost.R")

windows(10,3)
layout( matrix(1:3,nrow=1) )
par( mar=c(3,1,2.5,0) , mgp=c(2,0.7,0) )
histInfo = plotPost( a1SDSample , xlab="a1SD" , main="a1 SD" , showMode=T )
histInfo = plotPost( a2SDSample , xlab="a2SD" , main="a2 SD" , showMode=T )
histInfo = plotPost( a1a2SDSample , xlab="a1a2SD" , main="Interaction SD" ,
		showMode=T )
#savePlot(file=paste(fileNameRoot,"SD",sep=""),type="eps")

# Plot b values:
windows((dataList$Nx1Lvl+1)*2.75,(dataList$Nx2Lvl+1)*2.25)
layoutMat = matrix( 0 , nrow=(dataList$Nx2Lvl+1) , ncol=(dataList$Nx1Lvl+1) )
layoutMat[1,1] = 1
layoutMat[1,2:(dataList$Nx1Lvl+1)] = 1:dataList$Nx1Lvl + 1
layoutMat[2:(dataList$Nx2Lvl+1),1] = 1:dataList$Nx2Lvl + (dataList$Nx1Lvl + 1)
layoutMat[2:(dataList$Nx2Lvl+1),2:(dataList$Nx1Lvl+1)] = matrix(
		1:(dataList$Nx1Lvl*dataList$Nx2Lvl) + (dataList$Nx2Lvl+dataList$Nx1Lvl+1) ,
		ncol=dataList$Nx1Lvl , byrow=T )
layout( layoutMat )
par( mar=c(3,0.5,1.5,0.5) , mgp=c(2,0.7,0) )
histinfo = plotPost( b0Sample , xlab=expression(beta * 0) , main="Baseline" )
for ( x1idx in 1:dataList$Nx1Lvl ) {
	histinfo = plotPost( b1Sample[x1idx,] , xlab=bquote(beta*1[.(x1idx)]) ,
			main=paste("x1:",x1names[x1idx]) )
}
for ( x2idx in 1:dataList$Nx2Lvl ) {
	histinfo = plotPost( b2Sample[x2idx,] , xlab=bquote(beta*2[.(x2idx)]) ,
			main=paste("x2:",x2names[x2idx]) )
}
for ( x2idx in 1:dataList$Nx2Lvl ) {
	for ( x1idx in 1:dataList$Nx1Lvl ) {
		hdiLim = HDIofMCMC(b1b2Sample[x1idx,x2idx,])
		if ( hdiLim[1]>0 | hdiLim[2]<0 ) { compVal=0 } else { compVal=NULL }
		histinfo = plotPost( b1b2Sample[x1idx,x2idx,] , compVal=compVal ,
				xlab=bquote(beta*12[list(x1==.(x1idx),x2==.(x2idx))]) ,
				main=paste("x1:",x1names[x1idx],", x2:",x2names[x2idx])  )
	}
}
#savePlot(file=paste(fileNameRoot,"b",sep=""),type="eps")
source("HDIofMCMC.R")
x1ContrastLabels = c("Novices vs. Computer Experts", "Novices vs. Security Experts", "Computer Experts vs. Security Experts", "Non-Security Experts vs. Security Experts")
# Display contrast analyses
nContrasts = length( x1contrastList )
#x1PowerSample = matrix(rep(0,nContrasts*2),nrow=2)
if ( nContrasts > 0 ) {
	nPlotPerRow = 5
	nPlotRow = ceiling(nContrasts/nPlotPerRow)
	nPlotCol = ceiling(nContrasts/nPlotRow)
	windows(3.75*nPlotCol,2.5*nPlotRow)
	layout( matrix(1:(nPlotRow*nPlotCol),nrow=nPlotRow,ncol=nPlotCol,byrow=T) )
	par( mar=c(4,0.5,2.5,0.5) , mgp=c(2,0.7,0) )
	for ( cIdx in 1:nContrasts ) {
		contrast = matrix( x1contrastList[[cIdx]],nrow=1) # make it a row matrix
		incIdx = contrast!=0
		contrastValues = contrast %*% b1Sample;
		histInfo = plotPost( contrastValues , compVal=0 ,
				xlab="Differences in Mean Number of Fixations based on Expertise" ,
				cex.lab = 1.0 ,
				main=paste(x1ContrastLabels[cIdx] ),ROPE=c(-0.05,0.05) )
		#x1PowerSample[1,cIdx] = HDIofMCMC(contrastValues) < 0.0
		#x1PowerSample[2,cIdx] = HDIofMCMC(contrastValues) < -0.05
	}
	#savePlot(file=paste(fileNameRoot,"x1Contrasts",sep=""),type="eps")
}
#
x2ContrastLabels = c("Facebook vs. OpenID", "Task 1 vs. Others", "Task 6 vs. Others", "Task 1 and 6 vs. Others", "Facebook vs. OpenID w/o Tasks 1 and 6")
nContrasts = length( x2contrastList )
if ( nContrasts > 0 ) {
	nPlotPerRow = 5
	nPlotRow = ceiling(nContrasts/nPlotPerRow)
	nPlotCol = ceiling(nContrasts/nPlotRow)
	windows(3.75*nPlotCol,2.5*nPlotRow)
	layout( matrix(1:(nPlotRow*nPlotCol),nrow=nPlotRow,ncol=nPlotCol,byrow=T) )
	par( mar=c(4,0.5,2.5,0.5) , mgp=c(2,0.7,0) )
	for ( cIdx in 1:nContrasts ) {
		contrast = matrix( x2contrastList[[cIdx]],nrow=1) # make it a row matrix
		incIdx = contrast!=0
		histInfo = plotPost( contrast %*% b2Sample , compVal=0 ,
				xlab="Differences in Mean Number of Fixations based on Task" ,
				cex.lab = 1.0 ,
				main=paste(x2ContrastLabels[cIdx] ), ROPE=c(-0.05,0.05) )
	}
	#savePlot(file=paste(fileNameRoot,"x2Contrasts",sep=""),type="eps")
}
#
x1x2ContrastLabels = c("Novices vs. Security Experts\nTasks 1 and 6 Combined")
nContrasts = length( x1x2contrastList )
if ( nContrasts > 0 ) {
	nPlotPerRow = 5
	nPlotRow = ceiling(nContrasts/nPlotPerRow)
	nPlotCol = ceiling(nContrasts/nPlotRow)
	windows(3.75*nPlotCol,2.5*nPlotRow)
	layout( matrix(1:(nPlotRow*nPlotCol),nrow=nPlotRow,ncol=nPlotCol,byrow=T) )
	par( mar=c(4,0.5,2.5,0.5) , mgp=c(2,0.7,0) )
	for ( cIdx in 1:nContrasts ) {
		contrast = x1x2contrastList[[cIdx]]
		contrastArr = array( rep(contrast,chainLength) ,
				dim=c(NROW(contrast),NCOL(contrast),chainLength) )
		contrastLab = ""
		for ( x1idx in 1:Nx1Lvl ) {
			for ( x2idx in 1:Nx2Lvl ) {
				if ( contrast[x1idx,x2idx] != 0 ) {
					contrastLab = paste( contrastLab , "+" ,
							signif(contrast[x1idx,x2idx],2) ,
							x1names[x1idx] , x2names[x2idx] )
				}
			}
		}
		histInfo = plotPost( apply( contrastArr * b1b2Sample , 3 , sum ) ,
				compVal=0 , xlab="Difference in Mean Number of Fixations" , cex.lab = 0.75 ,
				main=paste( x1x2ContrastLabels[cIdx] ), ROPE=c(-0.05,0.05) )
	}
	#savePlot(file=paste(fileNameRoot,"x1x2Contrasts",sep=""),type="eps")
}

# Compute credible cell probability at each step in the MCMC chain
lambda12Sample = 0 * b1b2Sample
for ( chainIdx in 1:chainLength ) {
	lambda12Sample[,,chainIdx] = exp(
			b0Sample[chainIdx]
					+ outer( b1Sample[,chainIdx] , b2Sample[,chainIdx] , "+" )
					+ b1b2Sample[,,chainIdx] )
}
cellp = 0 * lambda12Sample
for ( chainIdx in 1:chainLength ) {
	cellp[,,chainIdx] = ( lambda12Sample[,,chainIdx]
				/ sum( lambda12Sample[,,chainIdx] ) )
}
# Display credible cell probabilities
windows(1440,960)
layoutMat = matrix( 1:(dataList$Nx2Lvl*dataList$Nx1Lvl) ,
		nrow=(dataList$Nx2Lvl) , ncol=(dataList$Nx1Lvl) , byrow=T )
layout( layoutMat )
par( mar=c(3,1,2,0.75) , mgp=c(2,0.7,0) )
maxp = max( cellp )
for ( x2idx in 1:dataList$Nx2Lvl ) {
	for ( x1idx in 1:dataList$Nx1Lvl ) {
		histinfo = plotPost( cellp[x1idx,x2idx,] ,
				breaks=seq(0,maxp,length=51) , xlim=c(0,maxp) ,
				xlab=bquote(probability[list(x1==.(x1names[x1idx]),x2==.(x2names[x2idx]))]) ,
				main=paste("x1:",x1names[x1idx],", x2:",x2names[x2idx]) ,
				HDItextPlace=0.95 )
	}
}
#savePlot(file=paste(fileNameRoot,"CellP",sep=""),type="eps")



#==============================================================================
# Do NHST ANOVA:

theData = data.frame( y=y , x1=factor(x1,labels=x1names) ,
                            x2=factor(x2,labels=x2names) )
windows()
interaction.plot( theData$x1 , theData$x2 , theData$y , type="b",xlab="Expertise Level",ylab="Mean Number of Fixations",trace.label="Task",pch=1:10 )
#savePlot( file=paste(fileNameRoot,"DataPlot",sep="") , type="eps" )
aovresult = aov( y ~ x1 * x2 , data = theData )
cat("\n------------------------------------------------------------------\n\n")
print( summary( aovresult ) )
cat("\n------------------------------------------------------------------\n\n")
print( model.tables( aovresult , type = "effects", se = TRUE ) , digits=3 )
cat("\n------------------------------------------------------------------\n\n")
TukeyHSD(aovresult)

var.test(theData$y[theData$x1!="Security Expert"],theData$y[theData$x1=="Security Expert"])
t.test(theData$y[theData$x1!="Security Expert"],theData$y[theData$x1=="Security Expert"])
library(coin)
logDuration = theData$y
secExpert = factor(theData$x1=="Security Expert",labels=c("Non-Security Expert","Security Expert"))
twoSample = data.frame(logDuration,secExpert)
wilcox_test(twoSample$logDuration~twoSample$secExpert,data=twoSample)
#==============================================================================
#
#obsFreq = matrix( 0 , nrow=Nx1Lvl , ncol=Nx2Lvl )
#for ( x1idx in 1:Nx1Lvl ) {
#	for ( x2idx in 1:Nx2Lvl ) {
#		obsFreq[x1idx,x2idx] = y[ theData[,2]==x1names[x1idx]
#						& theData[,3]==x2names[x2idx] ]
#	}
#}
#obsFreq = t(obsFreq) # merely to match orientation of histogram display
#chisqtest = chisq.test( obsFreq )
#print( "obs :" )
#print( chisqtest$observed )
#print( "( obs - exp )^2 / exp :" )
#print( ( chisqtest$observed - chisqtest$expected )^2 / chisqtest$expected )
#print( chisqtest )

