graphics.off()
rm(list=ls(all=TRUE))
fileNameRoot="ANOVAtwowayJagsSTZ" # for constructing output filenames
if ( .Platform$OS.type != "windows" ) { 
  windows <- function( ... ) X11( ... ) 
}
require(rjags)         
# Code modified by Timothy Kelley from: 
#
# Kruschke, J. K. (2011). Doing Bayesian Data Analysis:      
# A Tutorial with R and BUGS. Academic Press / Elsevier.
#------------------------------------------------------------------------------
# THE MODEL.

modelstring = "
model {
  for ( i in 1:Ntotal ) {
    y[i] ~ dnorm( mu[i] , tau )
    mu[i] <- a0 + a1[x1[i]] + a2[x2[i]] + a1a2[x1[i],x2[i]]
  }

  #
  tau <- pow( sigma , -2 )
		sigma ~ dunif(0,10) # y values are assumed to be standardized
		#
		a0 ~ dnorm(0,0.001) # y values are assumed to be standardized
		#
		for ( j1 in 1:Nx1Lvl ) { a1[j1] ~ dnorm( 0.0 , a1tau ) }
		a1tau <- 1 / pow( a1SD , 2 )
		a1SD ~dgamma(2.618,2.697) # mode=0.6,sd=0.6.		
		#a1SDunabs ~ dt( 0 , 0.01 , 2 )
		#
		for ( j2 in 1:Nx2Lvl ) { a2[j2] ~ dnorm( 0.0 , a2tau) }
		a2tau <- 1 / pow( a2SD , 2 )
		a2SD ~dgamma(2.618,2.697) # mode=0.6,sd=0.6.
		#a2SDunabs ~ dt( 0 , 0.01 , 2 )
		#
		for ( j1 in 1:Nx1Lvl ) { for ( j2 in 1:Nx2Lvl ) {
		a1a2[j1,j2] ~ dnorm( 0.0 , a1a2tau )
		} }
		a1a2tau <- 1 / pow( a1a2SD , 2 )
		a1a2SD ~dgamma(2.618,2.697) # mode=0.6,sd=0.6.
		#a1a2SDunabs ~ dt( 0 , 0.01 , 2 )
		#
  # Convert a0,a1[],a2[],a1a2[,] to sum-to-zero b0,b1[],b2[],b1b2[,] :
  for ( j1 in 1:Nx1Lvl ) { for ( j2 in 1:Nx2Lvl ) {
    m[j1,j2] <- a0 + a1[j1] + a2[j2] + a1a2[j1,j2]  
  } }
  b0 <- mean( m[1:Nx1Lvl,1:Nx2Lvl] )
  for ( j1 in 1:Nx1Lvl ) { b1[j1] <- mean( m[j1,1:Nx2Lvl] ) - b0 }
  for ( j2 in 1:Nx2Lvl ) { b2[j2] <- mean( m[1:Nx1Lvl,j2] ) - b0 }
  for ( j1 in 1:Nx1Lvl ) { for ( j2 in 1:Nx2Lvl ) {
    b1b2[j1,j2] <- m[j1,j2] - ( b0 + b1[j1] + b2[j2] )  
  } }
}
" # close quote for modelstring
writeLines(modelstring,con="model.txt")

#------------------------------------------------------------------------------
# THE DATA.

# Specify data source:
dataSource = c("fixationDurationAnalysis.csv")
if ( dataSource == "fixationDurationAnalysis.csv" ) {
	fileNameRoot = paste( fileNameRoot , dataSource , sep="" )
	initialImport = read.csv(dataSource,na.strings=c("NULL","","?"),colClasses=c("integer","factor","factor","factor","numeric","factor"))
	firstFilter = initialImport[!is.na(initialImport$Fixation.Duration),]
	firstFilter = firstFilter[firstFilter$Fixation.within.distance=="Yes",]
	Task = as.integer(as.factor(firstFilter$Task...part))
	Transubject = as.integer(as.factor(firstFilter$Subject))
	SmallCategory = as.integer(as.factor(firstFilter$Classification))
	logDuration = log(firstFilter$Fixation.Duration)
	firstFilter = cbind(firstFilter,Task)
	firstFilter = cbind(firstFilter,Transubject)
	firstFilter = cbind(firstFilter,SmallCategory)
	firstFilter = cbind(firstFilter,logDuration)
	
	Task_Type = Task
	Task_Type[Task_Type < 7] = 1
	Task_Type[Task_Type > 6] = 2
	
	rSecExpert = SmallCategory
	rSecExpert[rSecExpert<3] = 1
	rSecExpert[rSecExpert==3] = 2
	
	firstFilter = cbind(firstFilter,rSecExpert)
	
	firstFilter = cbind(firstFilter,Task_Type)
	taskIntersection = Task
	
	taskIntersection = sort(intersect(firstFilter$Task[firstFilter$SmallCategory==1|firstFilter$SmallCategory==2],firstFilter$Task[firstFilter$SmallCategory==3]))
	#use this for specific tasks, but general expertise.
	
	secondFilter = firstFilter[firstFilter$Task %in% taskIntersection,]
	newTaskNumber = as.integer(as.factor(secondFilter$Task))
	secondFilter = cbind(secondFilter,newTaskNumber)
	
	
	
	
	y = secondFilter$logDuration
	x1 = secondFilter$rSecExpert
	x2 = secondFilter$newTaskNumber
	Ntotal = length(y)
	Nx1Lvl = length(unique(x1))
	Nx2Lvl = length(unique(x2))

	x1names = as.factor(c("Non-Security Expert","Security Expert"))

	x2names = levels(as.factor(taskIntersection))
	
	
	normalize = function( v ){ return( v / sum(v) ) }

	x1ContrastList = list(OthersvSecExpert = (x1names!="Security Expert")-(x1names=="Security Expert"))
	x2ContrastList = list( FacebookvOpenID = normalize(x2names=="1"|x2names=="2"|x2names=="3"|x2names=="4"|x2names=="5"|x2names=="6")-
					normalize(x2names=="7"|x2names=="8"|x2names=="9"|x2names=="10"),
					Task1vOthers = (x2names=="1")-normalize(x2names!="1"),
					Task6vOthers = (x2names=="6")-normalize(x2names!="6"))
	x1x2ContrastList = list(OthersvSecExpertTask1 = outer(normalize(x1names!="Security Expert")-(x1names=="Security Expert"),(x2names=="1")),
			OthersvSecExpertTask6 = outer(normalize(x1names!="Security Expert")-(x1names=="Security Expert"),(x2names=="6")))

}

ySDorig = sd(y)
yMorig = mean(y)
z = ( y - yMorig ) / ySDorig
dataList = list(
		y = z ,
		x1 = x1 ,
		x2 = x2 ,
		Ntotal = Ntotal ,
		Nx1Lvl = Nx1Lvl ,
		Nx2Lvl = Nx2Lvl
)

#------------------------------------------------------------------------------
# INTIALIZE THE CHAINS.

theData = data.frame( y=dataList$y , x1=factor(x1,labels=x1names) ,
                            x2=factor(x2,labels=x2names) )
					
					
a0 = mean( theData$y )
a1 = aggregate( theData$y , list( theData$x1 ) , mean )[,2] - a0
a2 = aggregate( theData$y , list( theData$x2 ) , mean )[,2] - a0
linpred = as.vector( outer( a1 , a2 , "+" ) + a0 )
a1a2 = aggregate( theData$y, list(theData$x1,theData$x2), mean)[,3] - linpred
initsList = list(
            a0 = a0 ,
            a1 = a1 ,
            a2 = a2 ,
            a1a2 = matrix( a1a2 , nrow=Nx1Lvl , ncol=Nx2Lvl ) ,
            sigma = sd(theData$y)/2 , # lazy
            a1SD = sd(a1) ,
            a2SD = sd(a2) ,
            a1a2SD = sd(a1a2)
        )

#------------------------------------------------------------------------------
# RUN THE CHAINS

parameters = c( "a0" ,  "a1" ,  "a2" ,  "a1a2" , 
                "b0" ,  "b1" ,  "b2" ,  "b1b2" ,
                "sigma" , "a1SD" , "a2SD" , "a1a2SD" )
adaptSteps = 12000 
burnInSteps = 15000 
nChains = 25 
numSavedSteps=250000
thinSteps=75
nIter = ceiling( ( numSavedSteps * thinSteps ) / nChains )
# Create, initialize, and adapt the model:
jagsModel = jags.model( "model.txt" , data=dataList , inits=initsList , 
                        n.chains=nChains , n.adapt=adaptSteps )
# Burn-in:
cat( "Burning in the MCMC chain...\n" )
update( jagsModel , n.iter=burnInSteps )
# The saved MCMC chain:
cat( "Sampling final MCMC chain...\n" )
codaSamples = coda.samples( jagsModel , variable.names=parameters , 
                            n.iter=nIter , thin=thinSteps )
# resulting codaSamples object has these indices: 
#   codaSamples[[ chainIdx ]][ stepIdx , paramIdx ]

#------------------------------------------------------------------------------
# EXAMINE THE RESULTS

checkConvergence = T
if ( checkConvergence ) {
  show( summary( codaSamples ) )
  windows()
  plot( codaSamples , ask=F )  
  windows()
  autocorr.plot( codaSamples[[1]][,c("sigma","a1SD","a2SD","a1a2SD")] )
}

# Convert coda-object codaSamples to matrix object for easier handling.
# But note that this concatenates the different chains into one long chain.
# Result is mcmcChain[ stepIdx , paramIdx ]
mcmcChain = as.matrix( codaSamples )

source("plotPost.R")

# Extract and plot the SDs:
sigmaSample = mcmcChain[,"sigma"]*ySDorig
a1SDSample = mcmcChain[,"a1SD"]*ySDorig
a2SDSample = mcmcChain[,"a2SD"]*ySDorig
a1a2SDSample = mcmcChain[,"a1a2SD"]*ySDorig
windows()
layout( matrix(1:4,nrow=2) )
par( mar=c(3,1,2.5,0) , mgp=c(2,0.7,0) )
histInfo = plotPost( sigmaSample , xlab="sigma" , main="Cell SD" , showMode=T )
histInfo = plotPost( a1SDSample , xlab="a1SD" , main="a1 SD" , showMode=T )
histInfo = plotPost( a2SDSample , xlab="a2SD" , main="a2 SD" , showMode=T )
histInfo = plotPost( a1a2SDSample , xlab="a1a2SD" , main="Interaction SD" ,
                     showMode=T )
#savePlot( file=paste(fileNameRoot,"SD",sep="") , type="eps" )

# Extract b values:
b0Sample = mcmcChain[, "b0" ]
chainLength = length(b0Sample)
b1Sample = array( 0 , dim=c( dataList$Nx1Lvl , chainLength ) )
for ( x1idx in 1:dataList$Nx1Lvl ) {
   b1Sample[x1idx,] = mcmcChain[, paste("b1[",x1idx,"]",sep="") ]
}
b2Sample = array( 0 , dim=c( dataList$Nx2Lvl , chainLength ) )
for ( x2idx in 1:dataList$Nx2Lvl ) {
   b2Sample[x2idx,] = mcmcChain[, paste("b2[",x2idx,"]",sep="") ]
}
b1b2Sample = array(0, dim=c( dataList$Nx1Lvl , dataList$Nx2Lvl , chainLength ) )
for ( x1idx in 1:dataList$Nx1Lvl ) {
  for ( x2idx in 1:dataList$Nx2Lvl ) {
    b1b2Sample[x1idx,x2idx,] = mcmcChain[, paste( "b1b2[",x1idx,",",x2idx,"]",
                                                     sep="" ) ]
  }
}

# Convert from standardized b values to original scale b values:
b0Sample = b0Sample * ySDorig + yMorig
b1Sample = b1Sample * ySDorig
b2Sample = b2Sample * ySDorig
b1b2Sample = b1b2Sample * ySDorig

# Plot b values:
if ( Nx1Lvl <=6 & Nx2Lvl <=6 ) {
  windows((dataList$Nx1Lvl+1)*2.75,(dataList$Nx2Lvl+1)*2.0)
  layoutMat = matrix( 0 , nrow=(dataList$Nx2Lvl+1) , ncol=(dataList$Nx1Lvl+1) )
  layoutMat[1,1] = 1
  layoutMat[1,2:(dataList$Nx1Lvl+1)] = 1:dataList$Nx1Lvl + 1
  layoutMat[2:(dataList$Nx2Lvl+1),1] = 1:dataList$Nx2Lvl + (dataList$Nx1Lvl + 1)
  layoutMat[2:(dataList$Nx2Lvl+1),2:(dataList$Nx1Lvl+1)] = matrix(
      1:(dataList$Nx1Lvl*dataList$Nx2Lvl) + (dataList$Nx2Lvl+dataList$Nx1Lvl+1) ,
      ncol=dataList$Nx1Lvl , byrow=T )
  layout( layoutMat )
  par( mar=c(4,0.5,2.5,0.5) , mgp=c(2,0.7,0) )
  histinfo = plotPost( b0Sample , xlab=expression(beta * 0) , main="Baseline" )
  for ( x1idx in 1:dataList$Nx1Lvl ) {
    histinfo = plotPost( b1Sample[x1idx,] , xlab=bquote(beta*1[.(x1idx)]) ,
                         main=paste("x1:",x1names[x1idx]),ROPE=c(-0.05,0.05) )
  }
  for ( x2idx in 1:dataList$Nx2Lvl ) {
    histinfo = plotPost( b2Sample[x2idx,] , xlab=bquote(beta*2[.(x2idx)]) ,
                         main=paste("x2:",x2names[x2idx]),ROPE=c(-0.05,0.05) )
  }
  for ( x2idx in 1:dataList$Nx2Lvl ) {
    for ( x1idx in 1:dataList$Nx1Lvl ) {
      histinfo = plotPost( b1b2Sample[x1idx,x2idx,] , 
                xlab=bquote(beta*12[.(x1idx)*","*.(x2idx)]) ,
                main=paste("x1:",x1names[x1idx],", x2:",x2names[x2idx]),ROPE=c(-0.05,0.05)  )
    }
  }
  #savePlot( file=paste(fileNameRoot,"b",sep="") , type="eps" )
}
source("HDIofMCMC.R")
#x1ContrastLabels = c("Novices vs. Computer Experts", "Novices vs. Security Experts", "Computer Experts vs. Security Experts", "Security Non-Experts vs. Security Experts")
x1ContrastLabels = c("Non-Security Experts vs. Security Experts")
# Display contrast analyses
nContrasts = length( x1ContrastList )
x1PowerSample = matrix(rep(0,nContrasts*2),nrow=2)
if ( nContrasts > 0 ) {
	nPlotPerRow = 5
	nPlotRow = ceiling(nContrasts/nPlotPerRow)
	nPlotCol = ceiling(nContrasts/nPlotRow)
	windows(3.75*nPlotCol,2.5*nPlotRow)
	layout( matrix(1:(nPlotRow*nPlotCol),nrow=nPlotRow,ncol=nPlotCol,byrow=T) )
	par( mar=c(4,0.5,2.5,0.5) , mgp=c(2,0.7,0) )
	for ( cIdx in 1:nContrasts ) {
		contrast = matrix( x1ContrastList[[cIdx]],nrow=1) # make it a row matrix
		incIdx = contrast!=0
		contrastValues = contrast %*% b1Sample;
		histInfo = plotPost( contrastValues , compVal=0 ,
				xlab="Differences in Mean Log(Gaze Duration)" ,
				cex.lab = 1.0 ,
				main=paste(x1ContrastLabels[cIdx] ),ROPE=c(-0.05,0.05) )
		x1PowerSample[1,cIdx] = HDIofMCMC(contrastValues)[2] < 0.0
		x1PowerSample[2,cIdx] = HDIofMCMC(contrastValues)[2] < -0.05
	}
	#savePlot(file=paste(fileNameRoot,"x1Contrasts",sep=""),type="eps")
}
#
x2ContrastLabel = c("Facebook vs. OpenID", "Task 1 vs Other Tasks", "Task 6 vs Other Tasks")
nContrasts = length( x2ContrastList )
if ( nContrasts > 0 ) {
   nPlotPerRow = 5
   nPlotRow = ceiling(nContrasts/nPlotPerRow)
   nPlotCol = ceiling(nContrasts/nPlotRow)
   windows(3.75*nPlotCol,2.5*nPlotRow)
   layout( matrix(1:(nPlotRow*nPlotCol),nrow=nPlotRow,ncol=nPlotCol,byrow=T) )
   par( mar=c(4,0.5,2.5,0.5) , mgp=c(2,0.7,0) )
   for ( cIdx in 1:nContrasts ) {
       contrast = matrix( x2ContrastList[[cIdx]],nrow=1) # make it a row matrix
       incIdx = contrast!=0
       histInfo = plotPost( contrast %*% b2Sample , compVal=0 , 
                xlab="Differences in Mean Log(Gaze Duration)" ,
                cex.lab = 1.0 , 
                main=paste(x2ContrastLabel[cIdx] ),ROPE=c(-0.05,0.05) )
   }
   #savePlot( file=paste(fileNameRoot,"x2Contrasts",sep="") , type="eps" )
}
#
x1x2ContrastLabel = c("Non-Security Experts vs. Security Experts in Task 1", "Non-Security Experts vs. Security Experts in Task 6")
nContrasts = length( x1x2ContrastList )
if ( nContrasts > 0 ) {
   nPlotPerRow = 5
   nPlotRow = ceiling(nContrasts/nPlotPerRow)
   nPlotCol = ceiling(nContrasts/nPlotRow)
   windows(3.75*nPlotCol,2.5*nPlotRow)
   layout( matrix(1:(nPlotRow*nPlotCol),nrow=nPlotRow,ncol=nPlotCol,byrow=T) )
   par( mar=c(4,0.5,2.5,0.5) , mgp=c(2,0.7,0) )
   for ( cIdx in 1:nContrasts ) {
       contrast = x1x2ContrastList[[cIdx]]
       contrastArr = array( rep(contrast,chainLength) ,
                            dim=c(NROW(contrast),NCOL(contrast),chainLength) )
       contrastLab = ""
       for ( x1idx in 1:Nx1Lvl ) {
         for ( x2idx in 1:Nx2Lvl ) {
           if ( contrast[x1idx,x2idx] != 0 ) {
             contrastLab = paste( contrastLab , "+" ,
                                  signif(contrast[x1idx,x2idx],2) ,
                                  x1names[x1idx] , x2names[x2idx] )
           }
         }
       }
       histInfo = plotPost( apply( contrastArr * b1b2Sample , 3 , sum ) ,
                compVal=0 ,  xlab="Differences in Mean Log(Gaze Duration)" , cex.lab = 0.75 ,
                main=paste( x1x2ContrastLabel[cIdx] ),ROPE=c(-0.05,0.05) )
   }
   #savePlot( file=paste(fileNameRoot,"x1x2Contrasts",sep="") , type="eps" )
}

#==============================================================================
# Do NHST ANOVA:

#theData = data.frame( y=y , x1=factor(x1,labels=c("Novice","Computer Expert","Security Expert")) ,
#                            x2=factor(x2,labels=levels(as.factor(c("Facebook","OpenID")))) )
theData = data.frame( y=y , x1=factor(x1,labels=x1names) ,
                          x2=factor(x2,labels=x2names) )
windows()
interaction.plot( theData$x1 , theData$x2 , theData$y , type="b",pch=1:10,xlab="Expertise Level",ylab="Mean log(Gaze Duration)",trace.label="Task" )
savePlot( file=paste(fileNameRoot,"DataPlot",sep="") , type="eps" )
aovresult = aov( y ~ x1 * x2 , data = theData )
cat("\n------------------------------------------------------------------\n\n")
print( summary( aovresult ) )
cat("\n------------------------------------------------------------------\n\n")
print( model.tables( aovresult , type = "effects", se = TRUE ) , digits=3 )
cat("\n------------------------------------------------------------------\n\n")
TukeyHSD(aovresult)
var.test(theData$y[theData$x1!="Security Expert"],theData$y[theData$x1=="Security Expert"])
t.test(theData$y[theData$x1!="Security Expert"],theData$y[theData$x1=="Security Expert"])
library(coin)
logDuration = theData$y
secExpert = factor(theData$x1=="Security Expert",labels=c("Non-Security Expert","Security Expert"))
twoSample = data.frame(logDuration,secExpert)
wilcox_test(twoSample$logDuration~twoSample$secExpert,data=twoSample)
##==============================================================================
